import styled from 'styled-components';

export const ButtonStyled = styled.div`
  /*===============================================
 Container 
===============================================*/
width: 100%;
  /*===============================================
Theme 
===============================================*/
  .theme_full_width {
    button {
      background: ${({ bg, theme }) => (bg ? bg : theme.COLORS.GREEN_4)};
      color: ${({ color, theme }) => (color ? color : theme.COLORS.WHITE_1)};
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 8px;
      box-shadow: 0px 2px 12px -5px rgba(0, 0, 0, 0.5);
      font-size: ${({ theme }) => theme.FONTS.SIZE_4};
      font-family: prompt_medium;
    }
  }
  .theme_green {
    width: 100%;
    button {
      background: ${({ bg, theme }) => (bg ? bg : theme.COLORS.GREEN_4)};
      color: ${({ color, theme }) => (color ? color : theme.COLORS.WHITE_1)};
      width: 100%;
      padding: 10px;
      border: none;
      border-radius: 16px;
      box-shadow: 0px 2px 12px -5px rgba(0, 0, 0, 0.5);
      font-size: ${({ theme }) => theme.FONTS.SIZE_4};
      font-family: prompt_medium;
      font-weight: 700;
    }
  }
  .theme_normal {
    width: 100%;
    button {
      background: ${({ bg, theme }) => (bg ? bg : theme.COLORS.GREEN_4)};
      color: ${({ color, theme }) => (color ? color : theme.COLORS.WHITE_1)};
      width: 100%;
      padding: 10px;
      border: none;
      border-radius: 16px;
      box-shadow: 0px 2px 12px -5px rgba(0, 0, 0, 0.5);
      font-size: ${({ theme }) => theme.FONTS.SIZE_4};
      font-family: prompt_medium;
      font-weight: 400;
    }
  }
  .theme_large_green{
    button {
      background: ${({ bg, theme }) => (bg ? bg : theme.COLORS.GREEN_3)};
      color: ${({ color, theme }) => (color ? color : theme.COLORS.WHITE_1)};
      width: 100%;
      padding: 0 2.5rem;
      line-height:60px;
      border: none;
      border-radius: 8px;
      font-size: ${({ theme }) => theme.FONTS.SIZE_3};
      font-family: prompt_medium;
      font-weight: 300;
    }
  }
  .theme_transparent{
    button {
      background: transparent;
      color: ${({ color, theme }) => (color ? color : theme.COLORS.GREEN_3)};
      width: 100%;
      padding: 0 2.5rem;
      height:60px;
      border: none;
      border-radius: 8px;
      font-size: ${({ theme }) => theme.FONTS.SIZE_3};
      font-family: prompt_medium;
      font-weight: 300;
    }
  }
`;
