import React from 'react'
import { ButtonStyled } from './styled'
import cx from 'classnames'

export const Button = ({
  theme_full_width,
  theme_green,
  theme_normal,
  theme_large_green,
  theme_transparent,
  children,
  ...props
}) => {
  const customClass = cx({
    theme_full_width: theme_full_width,
    theme_green: theme_green,
    theme_normal: theme_normal,
    theme_large_green: theme_large_green,
    theme_transparent: theme_transparent,
  })
  return (
    <ButtonStyled>
      <div className={customClass}>
        <button {...props}>{children}</button>
      </div>
    </ButtonStyled>
  )
}
